#ifndef SYN_TREE_H
#define SYN_TREE_H

#include <iostream>
#include <cstdlib>
#include <vector>
#include "sym_table.hpp"
#include "graph.hpp"

class SynTreeNode {
public:
    virtual ~SynTreeNode() {}
    
    virtual SynTreeNode* Clone() const = 0;
    virtual void Print(std::ostream& s) const = 0;
    virtual void* Interpret(SymbolTable& st) const = 0;
};

class ConstNode : public SynTreeNode {
private:
    int _value;
public:
    ConstNode(int value);
    ConstNode(const ConstNode& cn);

    virtual SynTreeNode* Clone() const;
    virtual void Print(std::ostream& s) const;
    virtual void* Interpret(SymbolTable& st) const;
};

class StringNode : public SynTreeNode {
private:
    std::string _id;
public:
    StringNode(const std::string& s);
    StringNode(const StringNode& id);

    virtual SynTreeNode* Clone() const;
    virtual void Print(std::ostream& s) const;
    virtual void* Interpret(SymbolTable& st) const;
};

class GraneNode : public SynTreeNode {
private:
    SynTreeNode* _left;
    SynTreeNode* _right;
public:
    GraneNode(SynTreeNode* left, SynTreeNode* right);
    GraneNode(const GraneNode& gn);
    ~GraneNode();

    virtual SynTreeNode* Clone() const;
    virtual void Print(std::ostream& s) const;
    virtual void* Interpret(SymbolTable& st) const;
};

class CvorNode : public SynTreeNode {
private:
    SynTreeNode* _left;
    SynTreeNode* _right;
public:
    CvorNode(SynTreeNode* left, SynTreeNode* right);
    CvorNode(const CvorNode& gn);
    ~CvorNode();

    virtual SynTreeNode* Clone() const;
    virtual void Print(std::ostream& s) const;
    virtual void* Interpret(SymbolTable& st) const; 
};

class ListaCvorovaNode : public SynTreeNode {
private:
    SynTreeNode* _left;
    SynTreeNode* _right;
public:
    ListaCvorovaNode(SynTreeNode* left, SynTreeNode* right);
    ListaCvorovaNode(const ListaCvorovaNode& gn);
    ~ListaCvorovaNode();

    virtual SynTreeNode* Clone() const;
    virtual void Print(std::ostream& s) const;
    virtual void* Interpret(SymbolTable& st) const; 
};

class GrafNode : public SynTreeNode {
private:
    SynTreeNode* _exp;
public:
    GrafNode(SynTreeNode* exp);
    GrafNode(const GrafNode& gn);
    ~GrafNode();

    virtual SynTreeNode* Clone() const;
    virtual void Print(std::ostream& s) const;
    virtual void* Interpret(SymbolTable& st) const; 
};

class IdNode : public SynTreeNode {
private:
    std::string _name;
public:
    IdNode(const std::string& exp);
    IdNode(const IdNode& gn);
    ~IdNode();

    virtual SynTreeNode* Clone() const;
    virtual void Print(std::ostream& s) const;
    virtual void* Interpret(SymbolTable& st) const;
};

class ZagradeNode : public SynTreeNode {
private:
    SynTreeNode* _exp;
public:
    ZagradeNode(SynTreeNode* exp);
    ZagradeNode(const ZagradeNode& gn);
    ~ZagradeNode();

    virtual SynTreeNode* Clone() const;
    virtual void Print(std::ostream& s) const;
    virtual void* Interpret(SymbolTable& st) const; 
};

class ComplNode : public SynTreeNode {
private:
    SynTreeNode* _exp;
public:
    ComplNode(SynTreeNode* exp);
    ComplNode(const ComplNode& gn);
    ~ComplNode();

    virtual SynTreeNode* Clone() const;
    virtual void Print(std::ostream& s) const;
    virtual void* Interpret(SymbolTable& st) const; 
};

class BinaryOpNode : public SynTreeNode {
private:
    std::string _op;
    SynTreeNode* _left;
    SynTreeNode* _right;
public:
    BinaryOpNode(SynTreeNode* left, SynTreeNode* right, const std::string& op);
    BinaryOpNode(const BinaryOpNode& gn);
    ~BinaryOpNode();

    virtual SynTreeNode* Clone() const;
    virtual void Print(std::ostream& s) const;
    virtual void* Interpret(SymbolTable& st) const; 
};

class PrintNode : public SynTreeNode {
private:
    SynTreeNode* _exp;
    int _type;
public:
    PrintNode(SynTreeNode* exp, int type);
    PrintNode(const PrintNode& gn);
    ~PrintNode();

    virtual SynTreeNode* Clone() const;
    virtual void Print(std::ostream& s) const;
    virtual void* Interpret(SymbolTable& st) const; 
};

class DodelaNode : public SynTreeNode {
private:
    SynTreeNode* _exp;
    std::string _name;
public:
    DodelaNode(SynTreeNode* exp, const std::string& name);
    DodelaNode(const DodelaNode& gn);
    ~DodelaNode();

    virtual SynTreeNode* Clone() const;
    virtual void Print(std::ostream& s) const;
    virtual void* Interpret(SymbolTable& st) const; 
};

class UpdateNode : public SynTreeNode {
private:
    SynTreeNode* _exp;
    std::string _name;
public:
    UpdateNode(SynTreeNode* exp, const std::string& name);
    UpdateNode(const UpdateNode& gn);
    ~UpdateNode();

    virtual SynTreeNode* Clone() const;
    virtual void Print(std::ostream& s) const;
    virtual void* Interpret(SymbolTable& st) const; 
};

class ProgramNode : public SynTreeNode {
private:
    SynTreeNode* _exp;
public:
    ProgramNode(SynTreeNode* exp);
    ProgramNode(const ProgramNode& gn);
    ~ProgramNode();

    virtual SynTreeNode* Clone() const;
    virtual void Print(std::ostream& s) const;
    virtual void* Interpret(SymbolTable& st) const; 
};

class SequenceNode : public SynTreeNode {
private:
    std::vector<SynTreeNode*> _vec;
public:
    SequenceNode();
    SequenceNode(const SequenceNode& gn);
    ~SequenceNode();

    void AddStatement(SynTreeNode* exp);

    virtual SynTreeNode* Clone() const;
    virtual void Print(std::ostream& s) const;
    virtual void* Interpret(SymbolTable& st) const; 
};

class DropNode : public SynTreeNode {
private:
    std::string _name;
    int _node;
public:
    DropNode(const std::string& name, int node);

    virtual SynTreeNode* Clone() const;
    virtual void Print(std::ostream& s) const;
    virtual void* Interpret(SymbolTable& st) const; 
};

class AdjNode : public SynTreeNode {
private:
    std::string _name;
    int _node;
public:
    AdjNode(const std::string& name, int node);

    virtual SynTreeNode* Clone() const;
    virtual void Print(std::ostream& s) const;
    virtual void* Interpret(SymbolTable& st) const; 
};

#endif

