#ifndef SYM_TABLE_H
#define SYM_TABLE_H

#include <map>
#include <exception>
#include "graph.hpp"

class SymbolTable {

public:
    SymbolTable();
    SymbolTable(const SymbolTable& st);
    ~SymbolTable();
    SymbolTable& operator =(const SymbolTable& st);

    bool AddVariable(const std::string& s, Graph* g);
    bool Defined(const std::string& s);
    Graph* Value(const std::string& s);
    bool Update(const std::string& s, Graph* g);

private:
    std::map<std::string, Graph*> _promenljive;
};

#endif

