//
// Created by strahinja on 4/3/24.
//

#ifndef LLVM_PROJECT_CONSTANTPROPAGATIONINSTRUCTION_H
#define LLVM_PROJECT_CONSTANTPROPAGATIONINSTRUCTION_H

#include "llvm/IR/Function.h"
#include "llvm/IR/Instruction.h"
#include "llvm/IR/Instructions.h"
#include "llvm/IR/Value.h"
#include "llvm/IR/Constants.h"

#include <unordered_map>
#include <vector>

enum Status {
  Top,
  Bottom,
  Const
};

class ConstantPropagationInstruction {
private:
  llvm::Instruction *Instr;
  std::unordered_map<llvm::Value *, std::pair<Status, int>> StatusBefore;
  std::unordered_map<llvm::Value *, std::pair<Status, int>> StatusAfter;
  std::vector<ConstantPropagationInstruction *> Predecessors;

public:
  ConstantPropagationInstruction(llvm::Instruction *);
  void setStatusBefore(llvm::Value *, Status S, int value = 0);
  void setStatusAfter(llvm::Value *, Status S, int value = 0);
  void addPredecessor(ConstantPropagationInstruction *);
  llvm::Instruction *getInstruction();
  void addVariables(const std::vector<llvm::Value *> &Variables);
  std::vector<ConstantPropagationInstruction *> getPredecessors();
  Status getStatusBefore(llvm::Value *Variable);
  Status getStatusAfter(llvm::Value *Variable);
  int getValueBefore(llvm::Value *Variable);
  int getValueAfter(llvm::Value *Variable);
};

#endif // LLVM_PROJECT_CONSTANTPROPAGATIONINSTRUCTION_H
