#include "llvm/IR/Instruction.h"
#include "llvm/Transforms/Utils.h"
#include "llvm/Transforms/Utils/LoopPeel.h"
#include "llvm/Transforms/Utils/LoopSimplify.h"
#include "llvm/Transforms/Utils/LoopUtils.h"
#include "llvm/Transforms/Utils/SizeOpts.h"
#include "llvm/Transforms/Utils/UnrollLoop.h"
#include "llvm/Analysis/LoopAnalysisManager.h"
#include "llvm/Analysis/LoopInfo.h"
#include "llvm/Analysis/LoopUnrollAnalyzer.h"
#include "llvm/Transforms/Utils/BasicBlockUtils.h"
#include "llvm/Transforms/Utils/LoopUtils.h"
#include "llvm/ADT/Statistic.h"
#include "llvm/Pass.h"
#include "llvm/Analysis/LoopPass.h"
#include "llvm/IR/IRBuilder.h"
#include "llvm/Support/raw_ostream.h"
#include "llvm/IR/IRBuilder.h"
#include <algorithm>

using namespace llvm;

namespace {
struct OurLoopInversionPass : public LoopPass {

  static char ID; // Pass identification, replacement for typeid
  OurLoopInversionPass() : LoopPass(ID) {}


  bool runOnLoop(Loop *L, LPPassManager &LPM) override {
    std::unordered_map<Value *, Value *> Mapping;
    Instruction *Clone;

    BasicBlock *Header = L->getHeader();
    // Poslednji basic block u petlji
    BasicBlock *Last = L->getLoopLatch();

    for (Instruction &I : *Header) {
      Clone = I.clone();
      Mapping[&I] = Clone;

      Clone->insertBefore(Last->getTerminator());
      for (size_t i = 0; i < Clone->getNumOperands(); i++) {
        if (Mapping.find(Clone->getOperand(i)) != Mapping.end()) {
          Clone->setOperand(i, Mapping[Clone->getOperand(i)]);
        }
      }
    }

    Last->getTerminator()->eraseFromParent();
    return true;
  }
}; // end of struct OurLoopInversionPass
}  // end of anonymous namespace

char OurLoopInversionPass::ID = 0;
static RegisterPass<OurLoopInversionPass> X("loop-inversion", "",
                                              false /* Only looks at CFG */,
                                              false /* Analysis Pass */);